
/**
 * Write a description of class Album here.
 *
 * @author (your name)
 * @version (a version number or a date)
 */

import java.util.ArrayList;
import java.util.GregorianCalendar;

public class Album {
    private String title;
    private int year;
    private Performer performer;
    private Song[] songs;
    private ArrayList<String> credits;
    private GregorianCalendar releaseDate;
    
    public Album(String title, int year, Performer performer, 
                    Song[] songs, ArrayList<String> credits, 
                    GregorianCalendar releaseDate) {
        this.title = title;
        this.year = year;
        this.performer = performer;
        this.songs = songs;
        this.credits = credits;
        this.releaseDate = releaseDate;
    }
    
    public Album(String title, int year, Performer performer, 
                    Song[] songs, ArrayList<String> credits) {
        this.title = title;
        this.year = year;
        this.performer = performer;
        this.songs = songs;
        this.credits = credits;
    }
    
    public Album(String title, int year, Performer performer, Song[] songs) {
        this.title = title;
        this.year = year;
        this.performer = performer;
        this.songs = songs;
    }
    
    public Album(String title, int year, Performer performer, int noOfSongs) {
        this.title = title;
        this.year = year;
        this.performer = performer;
        this.songs = new Song[noOfSongs];
        for (int i = 0; i < noOfSongs; i++) {
            songs[i] = new Song();
            songs[i].setTitle("Default title");
            songs[i].setTime(180);
        }
    }
    
    public Album(String title, int year, Performer performer) {
        this.title = title;
        this.year = year;
        this.performer = performer;
    }
    
    public Album() {
    }
    
    public void prettyPrint() {
        System.out.println("Album: " + title + " (" + year + ")");
        System.out.println("Songs: ");
        for (int i = 0; i < songs.length; i++) {
            System.out.println('\t' + songs[i].getTitle());
        }
        System.out.println("Credits: ");
        for (int i = 0; i < credits.size(); i++) {
            System.out.println('\t' + credits.get(i));
        }
    }
    
    public void setTitle(String title) {
        if (!((title == "") || (title.length() > 100))) {
                this.title = title;
            // System.out.println("Error: title length inappropriate");
            // return;
        } else {
            System.out.println("Error: title length inappropriate");
        }
    }
    
    public String getTitle() {
        return this.title;
    }
    
    public void setYear(int year) {
        this.year = year;
    }
    
    public int getYear() {
        return this.year;
    }
    
    public void setPerformer(Performer performer) {
        this.performer = performer;
    }
    
    public Performer getPerformer() {
        return this.performer;
    }
    
    public void setSongs(Song[] songs) {
        this.songs = songs;
    }
    
    public Song[] getSongs() {
        return this.songs;
    }
    
    public void setCredits(ArrayList<String> credits) {
        this.credits = credits;
    }
    
    public ArrayList<String> getCredits() {
        return this.credits;
    }
    
    public void setReleaseDate(GregorianCalendar releaseDate) {
        this.releaseDate = releaseDate;
    }
    
    public GregorianCalendar getReleaseDate() {
        return this.releaseDate;
    }
}
